
package w83a.w83aUtilidadesComunes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

//import com.ejie.w83a.cache.W83ACacheMap;

/**
 * Clase que mantiene una hash de ficheros de configuracion. Es un patrn
 * singletton que se inicializa en un servlet mediante parmetro
 * <load-on-startup>-1 </load-on-startup>.
 * 
 *  
 */
public class W83AProperties implements java.io.Serializable{

	private static final long serialVersionUID=0;
	/**
	 * Unico contructor definido que ademas es privado. Para poder obtener una
	 * referencia se debe hacer a traves del metodo getInstance
	 * 
	 * @throws IOException
	 */
	private W83AProperties() throws IOException {
		log.fine("carga de properties en el W83APropertiesManager");

		properties = new Properties();
		InputStream in = getClass().getResourceAsStream(APPLICATION_PROPERTIES);
		if (in != null) {
			properties.load(in);

			Enumeration enume = properties.keys();
			while (enume.hasMoreElements()) {
				String key = (String) enume.nextElement();
				log.fine("[" + key + "] - [" + properties.getProperty(key)
						+ "]");
			}
		} else {
			log.warning("no se ha podido recuperar el fichero de propiedades");
		}
	}

	/**
	 * @param property
	 * @return valor de la propiedad. "" si no existe.
	 */
	public static synchronized String get(String property) {
		String rtdo = "";
		try {
			if (instance == null) {
				instance = new W83AProperties();
			}
			rtdo = properties.getProperty(property, "");
			log.info("[" + property + "] = [" + rtdo + "]");
		} catch (Exception e) {
			log
					.warning("Error al obtener el W83APropertiesManager (Exception): "
							+ e.getMessage());
		}

		return rtdo;
	}

	public static String getProperty(String codApp, String name)
			throws Exception {
		try {
			//Comprobamos si ya tenemos el fiichero cargado
			//Properties p = (Properties) props.get(codApp);
			Properties p = null;
			if (p == null) {
				try {
					// Carga del fichero
					String propertiesName = "/" + codApp + "/" + codApp
							+ ".properties";
					InputStream in = W83AProperties.class
							.getResourceAsStream(propertiesName);
					p = new Properties();
					p.load(in);

					//Cachemos el fichero para prximas veces
					//props.put(codApp, p);
				} catch (Exception e) {
					throw new Exception(e);
				}
			}

			// Extraccion de parametros
			String param = p.getProperty(name);

			if (param == null || param.equals("")) {
				throw new Exception("No se encuentra la propiedad " + name
						+ " en el fichero " + "de propiedades /" + codApp + "/"
						+ codApp + ".properties");
			}

			return param;
		} catch (Exception ex) {
			throw new Exception(ex);
		}
	}

	//private static W83ACacheMap props = new W83ACacheMap(1000 * 60 * 10, false);

	private static Logger log = Logger.getLogger(W83AProperties.class.getName());//NOPMD

	// Fichero de configuracin principal de la aplicacion
	private static final String APPLICATION_PROPERTIES = "/w83a/w83a.properties";

	// Hashtable donde se almacenan los ficheros de propiedades
	private static Properties properties;

	// Referencia a s mismo por tratarse de un singletton
	private static W83AProperties instance;
}